Program MP3_Logo; {V 1.0 vom 08.09.2000}

Const LCD_Char=   1;
      LCD_Befehl= 2;

Var LPT:       Word;
    LPT_Data:  Word;
    LPT_Stat:  Word;
    LPT_Cont:  Word;
    Wartezeit: Word;

Procedure LCD_Byte (d: Byte; m: Byte);    Forward;
Procedure LCD_Init;                       Forward;
Procedure LCD_Zeile (z: Byte; t: String); Forward;
Procedure LPT_GetPort;                    Forward;
Procedure Wait;                           Forward;

Procedure LCD_Byte;

Var LCD_B1: Byte;
    LCD_B2: Byte;

Begin
  Case m of
    LCD_Char:   Begin
                  Case d of
                                      {Dos:}
                    142: d:= 225; {}
                    132: d:= 225; {}
                    153: d:= 239; {}
                    148: d:= 239; {}
                    154: d:= 245; {}
                    129: d:= 245; {}
                    225: d:= 226; {}
                                      {Windows:}
                    196: d:= 225; {}
                    228: d:= 225; {}
                    214: d:= 239; {}
                    246: d:= 239; {}
                    220: d:= 245; {}
                    252: d:= 245; {}
                    223: d:= 226; {}
                  End;

                  LCD_B1:= 4;
                  LCD_B2:= 6;
                End;
    LCD_Befehl: Begin
                  LCD_B1:= 2;
                  LCD_B2:= 0;
                End;
  End;

  Asm
    mov dx, [LPT_Data]
    mov al, [d]
    out dx, al

    mov dx, [LPT_Cont]
    mov al, [LCD_B1]
    out dx, al

    call Wait

    mov al, [LCD_B2]
    out dx, al

    call Wait

    mov al, 0
    out dx, al

    call Wait;
  End;
End;

Procedure LCD_Init;

Var i1: Byte;

  Procedure long_Wait;

  Var i1: Byte;

  Begin
    For i1:= 1 to 150 do
      Wait;
  End;

Begin
  For i1:= 1 to 2 do
  Begin
    LCD_Byte ($30, LCD_Befehl);
    long_Wait;
    LCD_Byte ($30, LCD_Befehl);
    long_Wait;
    LCD_Byte ($38, LCD_Befehl);
    long_Wait;
    LCD_Byte (8, LCD_Befehl);
    long_Wait;
    LCD_Byte (8 + 4, LCD_Befehl);
    long_Wait;
    LCD_Byte (1, LCD_Befehl);
    long_Wait;
    LCD_Byte (6, LCD_Befehl);
    long_Wait;
    long_Wait;
    long_Wait;
  End;
End;

Procedure LCD_Zeile;

Var b:  Byte;
    i1: Byte;

Begin
  Case z of
    1: LCD_Byte (128 or  $0, LCD_Befehl);
    2: LCD_Byte (128 or $40, LCD_Befehl);
    3: LCD_Byte (128 or $14, LCD_Befehl);
    4: LCD_Byte (128 or $54, LCD_Befehl);
  End;

  b:= (20 - Length (t)) div 2 + 1;

  For i1:= 1 to 20 do
    If (i1 < b) or (i1 > Length (t) + b - 1) Then
      LCD_Byte (32, LCD_Char)
    Else
      LCD_Byte (Mem[Seg (t):Ofs (t) + i1 - b + 1], LCD_Char);
End;

Procedure LPT_GetPort;

Label no_PF, SetPortEnd;

Var n: Byte;

Begin
  n:= LPT - 1;

  Asm
    mov bl, [n]
    shl bl, 1
    mov bh, 0
    push es
    mov ax, 0040h            {Adresse der par. Schnittstelle ermitteln}
    mov es, ax
    mov ax, ES:[8+bx]
    pop es
    mov [LPT_Data], ax
    inc ax
    cmp ax, 8078h            {Portfolio?}
    jne no_PF
    mov [LPT_Cont], ax    {Status- und Steuerport}
    inc ax                  {sind beim Pofo vertauscht!}
    mov [LPT_Stat], ax
    jmp SetPortEnd
no_PF:
    mov [LPT_Stat], ax
    inc ax
    mov [LPT_Cont], ax
SetPortEnd:
  End;
End;

Procedure Wait;

Label Loop;

Begin
  Asm
    mov cx, [Wartezeit]
Loop:
    or cx,cx
    dec cx
    nop
    push ax
    pop ax
    jnz Loop
  End;
End;

Begin
  LPT:= 1;
  Wartezeit:= 6000;

  LPT_Getport;
  LCD_Init;

  LCD_Zeile (1, 'Hallo');
  LCD_Zeile (2, 'Display-Test');
  LCD_Zeile (3, 'Zeile 3');
  LCD_Zeile (4, 'Zeile 4');
End.